/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/


package cnrg.itx.datax.devices;

import  cnrg.itx.datax.jaudio.*;

/**
 * Queue structure that is optimized to store JAudioBlocks.  Makes use of the JAudioBlock.jabNext 
 * (which shouldn't be used by any other queue!!!).
 */
class JABQueue
{
	private JAudioBlock jabHead, jabTail;
	
	/**
	 * creates the queue
	 */
	public JABQueue()
	{
		jabHead = null;
		jabTail = null;
	}

	/**
	 * Puts a JAudioBlock into the queue.
	 * @param jab the block to enqueue
	 */
	public synchronized void enqueue(JAudioBlock jab)
	{
		jab.setNext(null);
		if (jabHead == null)
		{
			jabHead = jab;
			jabTail = jab;
		}
		else
		{
			jabTail.setNext(jab);
			jabTail = jab;
		}
	}

	/**
	 * removes a block from the queue.  
	 * @return JAudioBlock the block at the tail of the queue. null if there is none.
	 */
	public synchronized JAudioBlock dequeue()
	{
		JAudioBlock jabTemp = jabHead;
		if (jabTail == jabHead)
		{
			jabTail = null;
		}
		if (jabHead != null)
		{
			jabHead = jabHead.getNext();
		}
		return jabTemp;
	}
}
